/*
 * Decompiled with CFR 0.152.
 */
package com.vinlanx.gunfireoverhaul.client;

import com.vinlanx.gunfireoverhaul.PlayTrackedSoundPacket;
import com.vinlanx.gunfireoverhaul.client.PositionalSoundInstance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class ClientSoundHandler {
    private static final List<TrackedSound> activeTrackedSounds = Collections.synchronizedList(new ArrayList());

    public static void addTrackedSound(PlayTrackedSoundPacket msg) {
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(msg.getSoundId());
        if (sound != null) {
            activeTrackedSounds.add(new TrackedSound(msg.getPos(), sound, msg.getVolume(), msg.getPitch(), msg.getDelayTicks(), msg.isPlayerInHouse()));
        }
    }

    private static Vec3 calculateSoundPosition(Player player, Vec3 sourcePos, boolean isPlayerInHouse) {
        float FIXED_DISTANCE = 45.0f;
        Vec3 playerPos = player.m_146892_();
        Vec3 startPos = isPlayerInHouse ? sourcePos : playerPos;
        Vec3 endPos = isPlayerInHouse ? playerPos : sourcePos;
        ClipContext context = new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player);
        BlockHitResult hitResult = player.m_9236_().m_45547_(context);
        if (hitResult.m_6662_() == HitResult.Type.MISS) {
            Vec3 direction = sourcePos.m_82546_(playerPos).m_82541_();
            if (direction.m_82556_() < 0.001) {
                direction = player.m_20154_();
            }
            return playerPos.m_82549_(direction.m_82490_(45.0));
        }
        Vec3 hitPos = hitResult.m_82450_();
        Vec3 rayDir = endPos.m_82546_(startPos).m_82541_();
        return hitPos.m_82546_(rayDir.m_82490_(0.1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onClientTick() {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || mc.m_91106_() == null || activeTrackedSounds.isEmpty()) {
            return;
        }
        List<TrackedSound> list = activeTrackedSounds;
        synchronized (list) {
            Iterator<TrackedSound> iterator = activeTrackedSounds.iterator();
            while (iterator.hasNext()) {
                TrackedSound tracked = iterator.next();
                if (tracked.isFinished()) {
                    iterator.remove();
                    continue;
                }
                tracked.tick((Player)mc.f_91074_, mc.m_91106_(), mc.f_91074_.m_217043_());
            }
        }
    }

    private static class TrackedSound {
        final Vec3 sourcePos;
        final SoundEvent sound;
        final float volume;
        final float pitch;
        long delayTicks;
        PositionalSoundInstance soundInstance;
        boolean started = false;
        private int updateCooldown = 0;
        private final boolean isPlayerInHouse;

        TrackedSound(Vec3 sourcePos, SoundEvent sound, float volume, float pitch, long delayTicks, boolean isPlayerInHouse) {
            this.sourcePos = sourcePos;
            this.sound = sound;
            this.volume = volume;
            this.pitch = pitch;
            this.delayTicks = delayTicks;
            this.isPlayerInHouse = isPlayerInHouse;
        }

        public void tick(Player player, SoundManager soundManager, RandomSource random) {
            if (this.soundInstance != null && this.soundInstance.m_7801_()) {
                return;
            }
            if (!this.started) {
                --this.delayTicks;
                if (this.delayTicks <= 0L) {
                    Vec3 soundPos = ClientSoundHandler.calculateSoundPosition(player, this.sourcePos, this.isPlayerInHouse);
                    this.soundInstance = new PositionalSoundInstance(this.sound, SoundSource.AMBIENT, this.volume, this.pitch, random, soundPos.f_82479_, soundPos.f_82480_, soundPos.f_82481_);
                    soundManager.m_120367_((SoundInstance)this.soundInstance);
                    this.started = true;
                }
            } else {
                --this.updateCooldown;
                if (this.updateCooldown <= 0) {
                    this.updateCooldown = 10;
                    Vec3 newSoundPos = ClientSoundHandler.calculateSoundPosition(player, this.sourcePos, this.isPlayerInHouse);
                    this.soundInstance.updatePosition(newSoundPos);
                }
            }
        }

        public boolean isFinished() {
            return this.soundInstance != null && this.soundInstance.m_7801_();
        }
    }
}

